package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.ut.service.mappers

import org.junit.jupiter.api.BeforeEach
import org.junit.jupiter.api.Test
import org.koin.test.KoinTest
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.Department
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.DepartmentName
import ru.yandex.crm.apphost.kotlin.dal.departmentmanager.DepartmentNameId
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.DepartmentEntityMapper
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.impl.DepartmentEntityMapperImpl
import java.util.*
import kotlin.properties.Delegates
import kotlin.test.assertEquals
import kotlin.test.assertTrue

class DepartmentEntityMapperTests: KoinTest {

    private var mapper: DepartmentEntityMapper by Delegates.notNull()

    @BeforeEach
    fun beforeEach() {
        mapper = DepartmentEntityMapperImpl()
    }

    @Test
    fun `to protobuf model test`() {
        val name = DepartmentName(
            id = DepartmentNameId(department = Department(), languageCode = "ru"),
            name = "name"
        )

        val entity = Department(
            id = UUID.fromString("327ba20a-1d9c-4d73-8029-889656957e36"),
            organizationId = 1,
            parentDepartment = Department(id = UUID.fromString("49d51155-c672-4b28-896a-8a9bd39ab282")),
            names = mutableSetOf(name),
            isActive = true
        )

        val proto = mapper.toProtobufModel(entity)

        assertEquals(entity.id.toString(), proto.id)
        assertEquals(entity.organizationId, proto.data.organizationId)
        assertEquals(entity.parentDepartment?.id.toString(), proto.data.parentDepartmentId)
        assertTrue(proto.data.namesList.size == 1)
        assertEquals(proto.data.namesList.first().name, name.name)
        assertEquals(proto.data.namesList.first().languageCode, name.id?.languageCode)
    }
}
