package ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.ut.service.mappers

import org.junit.jupiter.api.BeforeEach
import org.junit.jupiter.api.Test
import org.koin.test.KoinTest
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.repository.DepartmentRepository.DepartmentUsersCount
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.DepartmentUsersCountMapper
import ru.yandex.crm.apphost.kotlin.handlers.departmentmanager.service.mappers.impl.DepartmentUsersCountMapperImpl
import kotlin.properties.Delegates
import kotlin.test.assertEquals

class DepartmentUsersCountMapperTests: KoinTest {

    private var mapper: DepartmentUsersCountMapper by Delegates.notNull()

    @BeforeEach
    fun beforeEach() {
        mapper = DepartmentUsersCountMapperImpl()
    }

    @Test
    fun `to protobuf model test`() {
        val membersCount = DepartmentUsersCount(
            departmentId = "327ba20a-1d9c-4d73-8029-889656957e36",
            usersCount = 1
        )

        val protoModel = mapper.toProtobufModel(membersCount, 1L)

        assertEquals("327ba20a-1d9c-4d73-8029-889656957e36", protoModel.departmentId)
        assertEquals(1, protoModel.usersCount)
        assertEquals(1L, protoModel.organizationId)
    }
}
