package ru.yandex.crm.apphost.kotlin.handlers.entitymanager

import org.koin.dsl.bind
import org.koin.dsl.binds
import org.koin.dsl.module
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.api.BusinessEntityService
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.api.EntityMetaNamesService
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.api.EntityMetaService
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.api.HttpParserHandler
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.api.HttpPresenterHandler
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.ComplexTypeManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.EntityAttributeNameManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.EntityMetaManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.EntityMetaNameManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.EntityMetaVersionManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.HierarchyConnectionManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.LinkedEntitiesManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.impl.ComplexTypeManagerImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.impl.EntityAttributeNameManagerImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.impl.EntityMetaManagerImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.impl.EntityMetaNameManagerImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.impl.EntityMetaVersionManagerImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.impl.LinkedEntitiesManagerImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.jooq.JooqHierarchyConnectionManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.AttributeValueProvider
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.EntityAttributeValueMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.EntityMetaMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.EntityRecordMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.EntitySchemaMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.AggregatorLinkMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.NameMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.ValidationResultMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl.AttributeValueProviderImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl.EntityAttributeValueMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl.EntityMetaMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl.EntityRecordMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl.EntitySchemaMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl.AggregatorLinkMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl.NameMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl.ValidationResultMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.BooleanAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.ComplexAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.DateAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.DoubleAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.EmailAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.EntityMetaVersionValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.EntityValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.IntAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.PhoneAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.SimpleAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.StringAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.TimeAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.TimestampAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.UuidAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.ValidatorFactory
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.BooleanAttributeValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.DateAttributeValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.DoubleAttributeValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.EmailAttributeValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.EntityMetaVersionValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.EntityValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.IntAttributeValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.LinkAttributeValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.PhoneAttributeValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.StringAttributeValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.TimeAttributeValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.TimestampAttributeValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.UuidAttributeValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.ValidatorFactoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.externaldata.ExternalDataCommandProvider
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.externaldata.jooq.JooqExternalDataCommandProvider
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.ComplexTypeRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityAttributeNameRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityAttributeRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityMetaNameRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityMetaRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityMetaVersionAttributeRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityMetaVersionRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.impl.EntityAttributeNameRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.impl.EntityAttributeRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.impl.EntityMetaNameRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.impl.EntityMetaRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.impl.EntityMetaVersionAttributeRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.impl.EntityMetaVersionRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.schema.EntityManagerSchema
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateSchema
import ru.yandex.crm.library.kotlin.service.HostBuilder
import ru.yandex.web.apphost.api.grpc.AppHostTypedServant

fun HostBuilder.withEntityManagerModule() = withModule(module {
    // schemas:
    single { EntityManagerSchema() } bind HibernateSchema::class

    // repositories:
    factory { params -> ComplexTypeRepository(params.get()) } bind ComplexTypeRepository::class
    factory { params -> EntityAttributeNameRepositoryImpl(params.get()) } bind EntityAttributeNameRepository::class
    factory { params -> EntityMetaNameRepositoryImpl(params.get()) } bind EntityMetaNameRepository::class
    factory { params -> EntityMetaRepositoryImpl(params.get()) } bind EntityMetaRepository::class
    factory { params -> EntityMetaVersionRepositoryImpl(params.get()) } bind EntityMetaVersionRepository::class
    factory { params -> EntityMetaVersionAttributeRepositoryImpl(params.get()) } bind EntityMetaVersionAttributeRepository::class
    factory { params -> EntityAttributeRepositoryImpl(params.get()) } bind EntityAttributeRepository::class

    // validators:
    single { BooleanAttributeValidatorImpl() } binds arrayOf(BooleanAttributeValidator::class, SimpleAttributeValidator::class)
    single { DateAttributeValidatorImpl() } binds arrayOf(DateAttributeValidator::class, SimpleAttributeValidator::class)
    single { DoubleAttributeValidatorImpl() } binds arrayOf(DoubleAttributeValidator::class, SimpleAttributeValidator::class)
    single { IntAttributeValidatorImpl() } binds arrayOf(IntAttributeValidator::class, SimpleAttributeValidator::class)
    single { StringAttributeValidatorImpl() } binds arrayOf(StringAttributeValidator::class, SimpleAttributeValidator::class)
    single { TimeAttributeValidatorImpl() } binds arrayOf(TimeAttributeValidator::class, SimpleAttributeValidator::class)
    single { TimestampAttributeValidatorImpl() } binds arrayOf(TimestampAttributeValidator::class, SimpleAttributeValidator::class)
    single { UuidAttributeValidatorImpl() } binds arrayOf(UuidAttributeValidator::class, SimpleAttributeValidator::class)
    single { EmailAttributeValidatorImpl() } binds arrayOf(EmailAttributeValidator::class, ComplexAttributeValidator::class)
    single { PhoneAttributeValidatorImpl() } binds arrayOf(PhoneAttributeValidator::class, ComplexAttributeValidator::class)
    single { LinkAttributeValidatorImpl() } bind ComplexAttributeValidator::class
    single { ValidatorFactoryImpl() } bind ValidatorFactory::class
    single { EntityValidatorImpl(get()) } bind EntityValidator::class
    single { EntityMetaVersionValidatorImpl() } bind EntityMetaVersionValidator::class

    // services:
    single { ComplexTypeManagerImpl() } bind ComplexTypeManager::class
    single { EntityMetaMapperImpl(get()) } bind EntityMetaMapper::class
    single { EntityMetaManagerImpl(get(), get()) } bind EntityMetaManager::class
    single { EntityMetaVersionManagerImpl() } bind EntityMetaVersionManager::class
    single { EntityMetaNameManagerImpl() } bind EntityMetaNameManager::class
    single { EntityAttributeNameManagerImpl() } bind EntityAttributeNameManager::class
    single { NameMapperImpl() } bind NameMapper::class
    single { AttributeValueProviderImpl() } bind AttributeValueProvider::class
    single { EntitySchemaMapperImpl(get()) } bind EntitySchemaMapper::class
    single { EntityRecordMapperImpl(get()) } bind EntityRecordMapper::class
    single { ValidationResultMapperImpl() } bind ValidationResultMapper::class
    single { EntityAttributeValueMapperImpl(get()) } bind EntityAttributeValueMapper::class
    single { JooqExternalDataCommandProvider(get()) } bind ExternalDataCommandProvider::class
    single { JooqHierarchyConnectionManager(get()) } bind HierarchyConnectionManager::class
    single { AggregatorLinkMapperImpl() } bind AggregatorLinkMapper::class
    single { LinkedEntitiesManagerImpl(get()) } bind LinkedEntitiesManager::class

    // gRPC services:
    single { EntityMetaNamesService(get(), get(), get()) } bind AppHostTypedServant::class
    single { EntityMetaService(get(), get(), get(), get()) } bind AppHostTypedServant::class
    single { BusinessEntityService(get(), get(), get(), get(), get(), get(), get(), get()) } bind AppHostTypedServant::class

    single { HttpParserHandler(get()) } bind AppHostPathHandler::class
    single { HttpPresenterHandler() } bind AppHostPathHandler::class
})
