package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.api

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.EntityAttributeNameManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.EntityMetaNameManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.NameMapper
import ru.yandex.crm.apphost.proto.EntityMetaManagerProto.DeleteEntityAttributeNameRequest
import ru.yandex.crm.apphost.proto.EntityMetaManagerProto.DeleteEntityAttributeNameResponse
import ru.yandex.crm.apphost.proto.EntityMetaManagerProto.DeleteEntityMetaNameRequest
import ru.yandex.crm.apphost.proto.EntityMetaManagerProto.DeleteEntityMetaNameResponse
import ru.yandex.crm.apphost.proto.EntityMetaManagerProto.UpdateEntityAttributeNameRequest
import ru.yandex.crm.apphost.proto.EntityMetaManagerProto.UpdateEntityAttributeNameResponse
import ru.yandex.crm.apphost.proto.EntityMetaManagerProto.UpdateEntityMetaNameRequest
import ru.yandex.crm.apphost.proto.EntityMetaManagerProto.UpdateEntityMetaNameResponse
import ru.yandex.crm.apphost.proto.EntityMetaNamesServiceBase
import ru.yandex.web.apphost.api.request.RequestMeta
import java.util.UUID

class EntityMetaNamesService(
    private val entityMetaNameManager: EntityMetaNameManager,
    private val entityAttributeNameManager: EntityAttributeNameManager,
    private val mapper: NameMapper
) : EntityMetaNamesServiceBase() {

    override fun updateMetaName(
        meta: RequestMeta,
        request: UpdateEntityMetaNameRequest
    ): UpdateEntityMetaNameResponse {
        val command = request.command
        val name = mapper.fromProtobufModel(command.name, UUID.fromString(command.entityMetaId))

        val newName = entityMetaNameManager.updateName(
            name,
            command.organizationId
        )
        val protobufName = mapper.toProtobufModel(newName)

        return UpdateEntityMetaNameResponse.newBuilder()
            .setEntityMetaName(protobufName)
            .build()
    }

    override fun deleteMetaName(
        meta: RequestMeta,
        request: DeleteEntityMetaNameRequest
    ): DeleteEntityMetaNameResponse {
        val command = request.command

        entityMetaNameManager.deleteName(
            command.organizationId,
            UUID.fromString(command.entityMetaId),
            command.languageCode
        )

        return DeleteEntityMetaNameResponse.newBuilder()
            .build()
    }

    override fun updateMetaAttributeName(
        meta: RequestMeta,
        request: UpdateEntityAttributeNameRequest
    ): UpdateEntityAttributeNameResponse {
        val command = request.command
        val name =
            mapper.fromProtobufModel(command.name, UUID.fromString(command.entityMetaId), command.attributeShortName)

        val newName = entityAttributeNameManager.updateName(
            command.organizationId,
            name
        )
        val protobufName = mapper.toProtobufModel(newName)

        return UpdateEntityAttributeNameResponse.newBuilder()
            .setEntityMetaName(protobufName)
            .build()
    }

    override fun deleteMetaAttributeName(
        meta: RequestMeta,
        request: DeleteEntityAttributeNameRequest
    ): DeleteEntityAttributeNameResponse {
        val command = request.command

        entityAttributeNameManager.deleteName(
            command.organizationId,
            UUID.fromString(command.entityMetaId),
            command.attributeShortName,
            command.languageCode
        )

        return DeleteEntityAttributeNameResponse.newBuilder()
            .build()
    }
}
