package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.api

import NAppHostHttp.Http
import com.google.protobuf.Message
import io.ktor.http.HttpStatusCode
import ru.yandex.crm.apphost.kotlin.common.apphost.AppHostPathHandler
import ru.yandex.crm.apphost.kotlin.common.apphost.PROTO_HTTP_RESPONSE
import ru.yandex.crm.apphost.kotlin.common.extensions.getAppHostType
import ru.yandex.crm.apphost.kotlin.common.extensions.getSingleRequestItemOrNull
import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager
import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager.EntityRecordsResponse
import ru.yandex.web.apphost.api.request.RequestContext

class HttpPresenterHandler : AppHostPathHandler {
    override val path: String = "/response/entitymeta"

    override fun handle(ctx: RequestContext) {
        val entityRecords = ctx.requestItems
            .filter { it.type == Entitymanager.EntityRecord.getDescriptor().getAppHostType() }
            .map { it.getProtobufData(Entitymanager.EntityRecord.getDefaultInstance()) }

        if (entityRecords.isNotEmpty()) {
            val content = EntityRecordsResponse.newBuilder()
                .addAllEntityRecords(entityRecords)
                .build()
            val response = buildHttpResponse(content)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }

        val validationResult = ctx.getSingleRequestItemOrNull(
            Entitymanager.EntityValidationResult.getDescriptor().getAppHostType()
        )
            ?.getProtobufData(Entitymanager.EntityValidationResult.getDefaultInstance())

        if (validationResult != null) {
            val response = buildHttpResponse(validationResult, HttpStatusCode.BadRequest)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }

        val entityMetas = ctx.requestItems
            .filter { it.type == Entitymanager.EntityMeta.getDescriptor().getAppHostType() }
            .map { it.getProtobufData(Entitymanager.EntityMeta.getDefaultInstance()) }
        if (entityMetas.isNotEmpty()) {
            val content = Entitymanager.EntityMetasResponse.newBuilder()
                .addAllEntityMetas(entityMetas)
                .build()
            val response = buildHttpResponse(content)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }

        val entityMetaVersions = ctx.requestItems
            .filter { it.type == Entitymanager.EntityMetaVersion.getDescriptor().getAppHostType() }
            .map { it.getProtobufData(Entitymanager.EntityMetaVersion.getDefaultInstance()) }
        if (entityMetaVersions.isNotEmpty()) {
            val content = Entitymanager.EntityMetaVersionsResponse.newBuilder()
                .addAllVersions(entityMetaVersions)
                .build()
            val response = buildHttpResponse(content)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }

        val metaNames = ctx.requestItems
            .filter { it.type == Entitymanager.EntityMetaName.getDescriptor().getAppHostType() }
            .map { it.getProtobufData(Entitymanager.EntityMetaName.getDefaultInstance()) }
        if (metaNames.isNotEmpty()) {
            val content = Entitymanager.EntityMetaNamesResponse.newBuilder()
                .addAllNames(metaNames)
                .build()
            val response = buildHttpResponse(content)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }

        val attributeNames = ctx.requestItems
            .filter { it.type == Entitymanager.EntityAttributeName.getDescriptor().getAppHostType() }
            .map { it.getProtobufData(Entitymanager.EntityAttributeName.getDefaultInstance()) }
        if (attributeNames.isNotEmpty()) {
            val content = Entitymanager.EntityAttributeNamesResponse.newBuilder()
                .addAllNames(attributeNames)
                .build()
            val response = buildHttpResponse(content)
            ctx.addProtobufItem(PROTO_HTTP_RESPONSE, response)
            return
        }
    }

    private fun buildHttpResponse(
        response: Message,
        statusCode: HttpStatusCode = HttpStatusCode.OK
    ): Http.THttpResponse {
        return Http.THttpResponse.newBuilder()
            .setContent(response.toByteString())
            .setStatusCode(statusCode.value)
            .build()
    }
}
