package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMeta
import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager
import java.util.*

interface EntityMetaManager {
    fun create(entityMeta: EntityMeta, organizationId: Long, userId: Long): EntityMeta

    fun get(organizationId: Long): Collection<EntityMeta>

    fun getById(organizationId: Long, entityMetaId: UUID): EntityMeta

    fun getByShortNameAndVersion(organizationId: Long, shortName: String, versionNumber: Int? = null): EntityMeta

    fun delete(organizationId: Long, entityMetaId: UUID)

    fun addAttributes(entityMetaId: UUID, organizationId: Long, userId: Long, attributes: Collection<Entitymanager.EntityAttribute>): EntityMeta
}
