package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.HierarchyConnection
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.HierarchyEntityData
import java.util.UUID

interface HierarchyConnectionManager {
    fun saveOrUpdate(hierarchyConnectedEntity: HierarchyConnection)

    fun delete(hierarchyConnectedEntity: HierarchyConnection)

    fun deleteOccurrences(
        organizationId: Long,
        firstMetaId: UUID,
        secondMetaId: UUID,
        firstEntityId: UUID? = null,
        secondEntityId: UUID? = null
    )

    fun getAllParents(
        hierarchyEntities: Collection<HierarchyEntityData>,
        organizationId: Long
    ): Collection<HierarchyEntityData>

    fun getAllChilds(
        hierarchyEntities: Collection<HierarchyEntityData>,
        organizationId: Long
    ): Collection<HierarchyEntityData>
}
