package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.FlatConnection
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.HierarchyConnection
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.LinkFilter
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.LinkedEntityData
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMeta
import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager
import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager.EntityAttribute
import ru.yandex.crm.proto.gallifrey.entitystorage.Entitystorage.EntityRecord
import java.util.UUID

interface LinkedEntitiesManager {
    fun getLinkedEntities(
        entityMeta: EntityMeta,
        attributes: Collection<Entitymanager.EntityRecordAttribute>,
        organizationId: Long
    ): Collection<LinkedEntityData>

    fun getHierarchyConnections(
        modifiedEntityId: UUID,
        entities: Collection<EntityRecord>,
        attributes: Collection<EntityAttribute>
    ): Collection<HierarchyConnection>

    fun saveConnections(hierarchyConnections: Collection<HierarchyConnection>)

    fun deleteConnections(hierarchyConnections: Collection<HierarchyConnection>)

    fun generateFlatConnections(
        hierarchyConnections: Collection<HierarchyConnection>,
        entities: Collection<EntityRecord>,
        organizationId: Long
    ): Collection<FlatConnection>

    fun getLinkFilters(entityMeta: EntityMeta, internalRecordId: Long): Collection<LinkFilter>
}
