package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.ComplexTypeManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.ComplexTypeRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.ComplexType
import ru.yandex.crm.library.kotlin.database.hibernate.getRepository
import ru.yandex.crm.library.kotlin.database.hibernate.transaction

class ComplexTypeManagerImpl : ComplexTypeManager {
    private var complexTypeList: List<ComplexType>? = null

    override fun getComplexTypeByName(name: String): ComplexType {
        // Replace with cache mechanism
        // Task - https://st.yandex-team.ru/CRM-18397
        if (complexTypeList == null) {
            complexTypeList = transaction {
                val repository = getRepository<ComplexTypeRepository>()
                repository.findAll()
            }
        }

        return complexTypeList!!.first { it.name.equals(name, true) }
    }
}
