package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.EntityAttributeNameManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.EntityAttributeNameContainer
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityAttributeNameRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityMetaVersionAttributeRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityAttributeName
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityAttributeNameId
import ru.yandex.crm.library.kotlin.database.hibernate.getRepository
import ru.yandex.crm.library.kotlin.database.hibernate.transaction
import java.util.*

class EntityAttributeNameManagerImpl : EntityAttributeNameManager {
    override fun updateName(
        organizationId: Long,
        nameContainer: EntityAttributeNameContainer
    ): EntityAttributeNameContainer {
        val newName = transaction {
            val entityVersionAttributeRepository = getRepository<EntityMetaVersionAttributeRepository>()
            val metaVersionAttribute = entityVersionAttributeRepository.findByEntityMetaIdAndOrganizationId(
                organizationId,
                nameContainer.entityMetaId,
                nameContainer.attributeShortName
            ) ?: error("The EntityMeta with ${nameContainer.entityMetaId} was not found")

            val entityAttributeRepository = getRepository<EntityAttributeNameRepository>()
            val newName = EntityAttributeName(
                EntityAttributeNameId(
                    metaVersionAttribute.id!!.entityAttribute,
                    nameContainer.languageCode
                ), nameContainer.name
            )
            entityAttributeRepository.save(newName)
        }

        return EntityAttributeNameContainer(
            nameContainer.entityMetaId,
            nameContainer.attributeShortName,
            newName.name!!,
            newName.id!!.languageCode!!
        )
    }

    override fun deleteName(
        organizationId: Long,
        entityMetaId: UUID,
        attributeShortName: String,
        languageCode: String
    ) {
        transaction {
            val repository = getRepository<EntityAttributeNameRepository>()
            val name = repository.findByEntityMetaIdAndShortName(
                organizationId,
                entityMetaId,
                attributeShortName,
                languageCode
            )
            if (name != null) {
                repository.delete(name)
            }
        }
    }
}
