package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.EntityMetaNameManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.EntityMetaNameContainer
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityMetaNameRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityMetaRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaName
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaNameId
import ru.yandex.crm.library.kotlin.database.hibernate.getRepository
import ru.yandex.crm.library.kotlin.database.hibernate.transaction
import java.util.*

class EntityMetaNameManagerImpl : EntityMetaNameManager {
    override fun updateName(name: EntityMetaNameContainer, organizationId: Long): EntityMetaNameContainer {
        val newName = transaction {
            val entityMetaRepository = getRepository<EntityMetaRepository>()
            val entityMeta = entityMetaRepository.findById(organizationId, name.entityMetaId)
                ?: error("The EntityMeta with ${name.entityMetaId} was not found")
            val nameRepository = getRepository<EntityMetaNameRepository>()
            val newName = EntityMetaName(EntityMetaNameId(entityMeta, name.languageCode), name = name.name)

            nameRepository.save(newName)
        }

        return EntityMetaNameContainer(newName.id!!.entityMeta.id!!, newName.name!!, newName.id!!.languageCode!!)
    }

    override fun deleteName(organizationId: Long, entityMetaId: UUID, languageCode: String) {
        transaction {
            val repository = getRepository<EntityMetaNameRepository>()
            val metaName = repository.findByEntityMetaId(organizationId, entityMetaId, languageCode)
            if (metaName != null) {
                repository.delete(metaName)
            }
        }
    }

}
