package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.EntityMetaVersionManager
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityMetaVersionRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersion
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityVersionStatus
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityVersionStatusEnum
import ru.yandex.crm.library.kotlin.database.hibernate.getRepository
import ru.yandex.crm.library.kotlin.database.hibernate.transaction
import java.time.Instant
import java.util.*

class EntityMetaVersionManagerImpl : EntityMetaVersionManager {
    override fun activateCurrentDraft(
        organizationId: Long,
        entityMetaId: UUID,
        activateUserId: Long
    ): EntityMetaVersion {
        return transaction {
            val repository = getRepository<EntityMetaVersionRepository>()
            val draftVersion = repository.findDraftByEntityMetaId(organizationId, entityMetaId)
                ?: error("There is no draft version for EntityMeta with $entityMetaId id")

            val activeVersion = repository.findActiveByEntityMetaId(organizationId, entityMetaId)

            if (activeVersion != null) {
                activeVersion.status = EntityVersionStatus(EntityVersionStatusEnum.OUTDATED.value)
                activeVersion.changedBy = activateUserId
                activeVersion.changedAt = Instant.now()
                repository.save(activeVersion)
            }
            draftVersion.status = EntityVersionStatus(EntityVersionStatusEnum.ACTIVE.value)
            draftVersion.changedBy = activateUserId
            draftVersion.changedAt = Instant.now()

            repository.save(draftVersion)
            return@transaction draftVersion
        }
    }
}
