package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMeta
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersion
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute
import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager

interface EntityMetaMapper {
    fun fromProtobufModel(entityMeta: Entitymanager.EntityMeta): EntityMeta

    fun fromProtobufModel(entityMetaData: Entitymanager.EntityMetaData): EntityMeta

    fun fromProtobufModel(
        attributes: Collection<Entitymanager.EntityAttribute>,
        entityMeta: EntityMeta,
        entityMetaVersion: EntityMetaVersion,
        fieldNumberCounter: Int)
        : MutableSet<EntityMetaVersionAttribute>

    fun toProtobufModel(entityMeta: EntityMeta): Entitymanager.EntityMeta

    fun toProtobufModel(entityMetaVersion: EntityMetaVersion): Entitymanager.EntityMetaVersion
}
