package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.extension

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityAttribute
import java.time.Instant
import java.time.LocalDate
import java.time.LocalTime
import java.util.*

internal fun EntityAttribute.toIntValue(value: String): Int? {
    if (value.isNotEmpty()) {
        return value.toInt()
    }

    return integerParameter?.defaultValue
}

internal fun EntityAttribute.toDoubleValue(value: String): Double? {
    if (value.isNotEmpty()) {
        return value.toDouble()
    }

    return doubleParameter?.defaultValue
}

internal fun EntityAttribute.toStringValue(value: String): String? {
    if (value.isNotEmpty()) {
        return value
    }

    return stringParameter?.defaultValue
}

internal fun EntityAttribute.toDateValue(value: String): LocalDate? {
    if (value.isNotEmpty()) {
        return LocalDate.parse(value)
    }

    if (dateParameter?.defaultValue != null) {
        return dateParameter?.defaultValue
    }

    if (dateParameter?.todayIsDefault == true) {
        return LocalDate.now()
    }

    return null
}

internal fun EntityAttribute.toTimeValue(value: String): LocalTime? {
    if (value.isNotEmpty()) {
        return LocalTime.parse(value)
    }

    if (timeParameter?.defaultValue != null) {
        return timeParameter?.defaultValue
    }

    if (timeParameter?.nowIsDefault == true) {
        return LocalTime.now()
    }

    return null
}

internal fun EntityAttribute.toInstantValue(value: String): Instant? {
    if (value.isNotEmpty()) {
        return Instant.parse(value)
    }

    if (timestampParameter?.defaultValue != null) {
        return timestampParameter?.defaultValue
    }

    if (timestampParameter?.nowIsDefault == true) {
        return Instant.now()
    }

    return null
}

internal fun EntityAttribute.toBooleanValue(value: String): Boolean {
    return value.toBoolean()
}

internal fun EntityAttribute.toUuidValue(value: String): UUID? {
    if (value.isNotEmpty()) {
        return UUID.fromString(value)
    }

    return null
}
