package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.SimpleTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.SimpleType
import ru.yandex.crm.proto.gallifrey.entitystorage.Entitystorage.AttributeSchema.AttributeType

fun SimpleType.toAttributeType() : AttributeType {
    return when (toEnum()) {
        SimpleTypeEnum.TIMESTAMP -> AttributeType.TIMESTAMP
        SimpleTypeEnum.INT -> AttributeType.INT
        SimpleTypeEnum.BOOL -> AttributeType.BOOL
        SimpleTypeEnum.UUID -> AttributeType.UUID
        else -> AttributeType.STRING
    }
}

fun SimpleType.toEnum() = SimpleTypeEnum.values().first { it.value == id }
