package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.AggregatorLinkMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.FlatConnection
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.LinkEntityFilter
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.LinkFilter
import ru.yandex.crm.apphost.proto.Aggregator
import ru.yandex.crm.apphost.proto.Aggregator.Link

class AggregatorLinkMapperImpl: AggregatorLinkMapper {

    override fun toLinkProtobufModel(
        connections: Collection<FlatConnection>
    ): Collection<Link> =
        connections
            .map { toProtobufModel(it) }

    override fun toFilterProtobufModel(linkFilters: Collection<LinkFilter>): Collection<Aggregator.LinkFilter> =
        linkFilters.map { toProtobufModel(it) }

    private fun toProtobufModel(connection: FlatConnection): Link {
        return Link.newBuilder()
            .setFirst(
                Aggregator.EntityRecordId.newBuilder()
                    .setMetaId(connection.firstMetaId.toString())
                    .setRecordInternalId(connection.firstEntityInternalId)
            )
            .setSecond(
                Aggregator.EntityRecordId.newBuilder()
                    .setMetaId(connection.secondMetaId.toString())
                    .setRecordInternalId(connection.secondEntityInternalId)
            )
            .build()
    }

    private fun toProtobufModel(linkFilter: LinkFilter): Aggregator.LinkFilter {
        val builder = Aggregator.LinkFilter.newBuilder()

        if (linkFilter.first != null) {
            builder.first = toProtobufModel(linkFilter.first)
        } else if (linkFilter.second != null) {
            builder.second = toProtobufModel(linkFilter.second)
        }

        return builder
            .build()
    }

    private fun toProtobufModel(linkEntityFilter: LinkEntityFilter): Aggregator.EntityRecordFilter {
        val builder = Aggregator.EntityRecordFilter.newBuilder()
            .setEntityId(Aggregator.EntityRecordId.newBuilder()
                .setMetaId(linkEntityFilter.metaId)
                .setRecordInternalId(linkEntityFilter.recordInternalId))

        if (linkEntityFilter.linkedMetaId != null) {
            builder.linkedMetaId = linkEntityFilter.linkedMetaId
        }

        return builder.build()
    }
}
