package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.AttributeValueProvider
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.extension.*
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.extension.toDateValue
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.extension.toDoubleValue
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.extension.toIntValue
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.extension.toStringValue
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.SimpleTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityAttribute

class AttributeValueProviderImpl : AttributeValueProvider {
    private val valueConvertersMap = mapOf<SimpleTypeEnum, (attribute: EntityAttribute, value: String) -> Any?>(
        SimpleTypeEnum.INT to EntityAttribute::toIntValue,
        SimpleTypeEnum.DOUBLE to EntityAttribute::toDoubleValue,
        SimpleTypeEnum.STRING to EntityAttribute::toStringValue,
        SimpleTypeEnum.DATE to EntityAttribute::toDateValue,
        SimpleTypeEnum.TIME to EntityAttribute::toTimeValue,
        SimpleTypeEnum.TIMESTAMP to EntityAttribute::toInstantValue,
        SimpleTypeEnum.BOOL to EntityAttribute::toBooleanValue,
        SimpleTypeEnum.UUID to EntityAttribute::toUuidValue
    )

    override fun getValue(attribute: EntityAttribute, value: String): Any? {
        return valueConvertersMap[attribute.complexType.simpleType.toEnum()]?.invoke(attribute, value)
    }
}
