package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.EntityAttributeValueMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.EntityRecordMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMeta
import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager
import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager.EntityRecordAttribute
import ru.yandex.crm.proto.gallifrey.entitystorage.Entitystorage.*

class EntityRecordMapperImpl(
    private val entityAttributeValueMapper: EntityAttributeValueMapper
) : EntityRecordMapper {
    override fun toEntityRecord(
        recordData: Entitymanager.EntityRecordData,
        entityMeta: EntityMeta,
        entitySchema: EntitySchema,
        users: Collection<EntityUser>,
        organizationId: Long,
    ): EntityRecord {
        val metaVersionAttributes = entityMeta.entityMetaVersions.first().attributes
        val metaAttributesMap = metaVersionAttributes.associateBy { it.shortName!! }

        val entityRecord = EntityRecord.newBuilder()
            .setDepartmentId(recordData.departmentId)
            .setMetaId(entitySchema.metaId)
            .setOrganizationId(organizationId)
        val attributesSchemasMap = entitySchema.attributesList.associateBy { it.name }

        recordData.attributesList.forEach {
            val metaAttribute = metaAttributesMap[it.name]!!
            val attribute = Attribute.newBuilder()
                .setSchema(attributesSchemasMap[it.name])
                .setValue(entityAttributeValueMapper.toProtoAttributeValue(metaAttribute.id!!.entityAttribute, it.value))

            entityRecord.addAttributes(attribute.build())
        }

        entityRecord.addAllUsers(users)
        return entityRecord.build()
    }

    override fun toEntityRecords(entitiesResponse: EntityResponse, entityMeta: Entitymanager.EntityMeta): Collection<Entitymanager.EntityRecord> {
        return entitiesResponse.entitiesList.map { mapEntityRecord(it, entityMeta) }
    }

    private fun mapEntityRecord(entityRecord: EntityRecord, entityMeta: Entitymanager.EntityMeta): Entitymanager.EntityRecord {
        return Entitymanager.EntityRecord.newBuilder()
            .setId(entityRecord.id)
            .setInternalId(entityRecord.internalId)
            .setOrganizationId(entityRecord.organizationId)
            .setEntityRecordVersion(entityRecord.version)
            .setEntityMetaShortName(entityMeta.data.shortName)
            .setDepartmentId(entityRecord.departmentId)
            .addAllAttributes(entityRecord.attributesList.map { mapEntityAttribute(it) })
            .build()
    }

    private fun mapEntityAttribute(attribute: Attribute): EntityRecordAttribute {
        val builder = EntityRecordAttribute.newBuilder()
            .setName(attribute.schema.name)
            .setValue(entityAttributeValueMapper.fromProtoAttributeValue(attribute.value))

        return builder.build()
    }
}
