package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.constant.EntityRecordField
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.EntityAttributeValueMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.EntitySchemaMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.ComplexType
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMeta
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute
import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager
import ru.yandex.crm.proto.gallifrey.entitystorage.Entitystorage

class EntitySchemaMapperImpl(
    private val entityAttributeValueMapper: EntityAttributeValueMapper
) : EntitySchemaMapper {
    override fun toProtoEntitySchema(entityMeta: EntityMeta): Entitystorage.EntitySchema {
        return Entitystorage.EntitySchema.newBuilder()
            .setMetaId(entityMeta.id.toString())
            .setOrganizationId(entityMeta.organizationId!!)
            .addAllAttributes(toProtoAttributeSchemas(entityMeta.entityMetaVersions.first().attributes))
            .build()
    }

    override fun toAttributeFilters(
        filters: Collection<Entitymanager.EntityAttributeFilter>,
        entityMeta: EntityMeta,
        entitySchema: Entitystorage.EntitySchema
    ): Collection<Entitystorage.AttributeFilter> {
        val attributeSchemas = entitySchema.attributesList.associateBy { it.name }
        val entityMetaAttributes = entityMeta.entityMetaVersions.first().attributes
            .associateBy { it.shortName!! }

        return filters.flatMap { filter ->
            if (filter.attributeShortName == EntityRecordField.ID_FIELD_NAME) {
                listOf(entityAttributeValueMapper.getIdFilter(filter.expressionsList.first().stringFilter.value))
            } else if (filter.attributeShortName == EntityRecordField.INTERNAL_ID_FIELD_NAME) {
                // TODO: adding filter by internal id
                listOf()
            } else {
                val attributeName = filter.attributeShortName
                val attribute = entityMetaAttributes[attributeName]!!.id!!.entityAttribute
                // TODO: тут надо смержить фильтры на числа: "больше(-равно)" + "меньше(равно)" должны стать одним фильтром с мин/макс значением
                filter.expressionsList.map {
                    entityAttributeValueMapper.toProtoAttributeFilter(attribute, it, attributeSchemas[attributeName]!!)
                }
            }
        }
    }

    private fun toProtoAttributeSchemas(entityMetaAttributes: MutableSet<EntityMetaVersionAttribute>): Collection<Entitystorage.AttributeSchema> {
        return entityMetaAttributes.map { toProtoAttributeSchema(it) }
    }

    private fun toProtoAttributeSchema(attribute: EntityMetaVersionAttribute): Entitystorage.AttributeSchema {
        return Entitystorage.AttributeSchema.newBuilder()
            .setName(attribute.shortName)
            .setFieldNumber(attribute.id!!.entityAttribute.fieldNumber!!)
            .setType(mapAttributeType(attribute.id!!.entityAttribute.complexType))
            .setIsIndexed(true)
            .build()
    }

    private fun mapAttributeType(type: ComplexType): Entitystorage.AttributeSchema.AttributeType {
        return type.simpleType.toAttributeType()
    }
}
