package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.NameMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.EntityAttributeNameContainer
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.EntityMetaNameContainer
import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager
import java.util.*

class NameMapperImpl : NameMapper {
    override fun fromProtobufModel(
        entityMetaName: Entitymanager.EntityMetaNameData,
        entityMetaId: UUID
    ): EntityMetaNameContainer {
        return EntityMetaNameContainer(
            entityMetaId = entityMetaId,
            name = entityMetaName.name,
            languageCode = entityMetaName.languageCode
        )
    }

    override fun fromProtobufModel(
        entityAttributeName: Entitymanager.EntityAttributeNameData,
        entityMetaId: UUID,
        attributeShortName: String
    ): EntityAttributeNameContainer {
        return EntityAttributeNameContainer(
            entityMetaId,
            attributeShortName,
            entityAttributeName.name,
            entityAttributeName.languageCode
        )
    }

    override fun toProtobufModel(nameContainer: EntityMetaNameContainer): Entitymanager.EntityMetaName {
        return Entitymanager.EntityMetaName.newBuilder()
            .setEntityMetaId(nameContainer.entityMetaId.toString())
            .setName(
                Entitymanager.EntityMetaNameData.newBuilder()
                    .setName(nameContainer.name)
                    .setLanguageCode(nameContainer.languageCode)
                    .build()
            )
            .build()
    }

    override fun toProtobufModel(nameContainer: EntityAttributeNameContainer): Entitymanager.EntityAttributeName {
        return Entitymanager.EntityAttributeName.newBuilder()
            .setEntityMetaId(nameContainer.entityMetaId.toString())
            .setAttributeShortName(nameContainer.attributeShortName)
            .setName(
                Entitymanager.EntityAttributeNameData.newBuilder()
                    .setName(nameContainer.name)
                    .setLanguageCode(nameContainer.languageCode)
                    .build()
            )
            .build()
    }
}
