package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.ValidationResultMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.EntityValidationResult
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResult
import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager

class ValidationResultMapperImpl : ValidationResultMapper {
    override fun toProtoValidationResult(validationResult: EntityValidationResult): Entitymanager.EntityValidationResult {
        return Entitymanager.EntityValidationResult.newBuilder()
            .addAllAttributeValidations(validationResult.results.map { toAttributeValidationResult(it) })
            .build()
    }

    private fun toAttributeValidationResult(result: ValidationResult): Entitymanager.AttributeValidationResult {
        return Entitymanager.AttributeValidationResult.newBuilder()
            .setAttributeName(result.attributeName)
            .setValidationMessage(result.reason?.message)
            .build()
    }
}
