package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.SimpleAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResult
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResultReason
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute

abstract class AttributeValidatorBase: SimpleAttributeValidator {
    override fun validate(value: String, entityAttribute: EntityMetaVersionAttribute): ValidationResult {
        val attributeName = getAttributeName(entityAttribute)
        if (value.isEmpty() && entityAttribute.id!!.entityAttribute.isRequired!! && !entityAttribute.id!!.entityAttribute.isNullable!!) {
            return ValidationResult(attributeName, reason = ValidationResultReason.REQUIRED)
        }

        return ValidationResult(attributeName, true)
    }

    protected fun getAttributeName(entityAttribute: EntityMetaVersionAttribute): String {
        return entityAttribute.shortName!!
    }
}
