package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.SimpleTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.DoubleAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.annotation.SimpleTypeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResult
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResultReason
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute

@SimpleTypeValidator(SimpleTypeEnum.DOUBLE)
class DoubleAttributeValidatorImpl: AttributeValidatorBase(), DoubleAttributeValidator {
    override fun validate(value: String, entityAttribute: EntityMetaVersionAttribute): ValidationResult {
        val baseResult = super.validate(value, entityAttribute)
        val attribute = entityAttribute.id!!.entityAttribute
        if (!baseResult.isValid && attribute.doubleParameter!!.defaultValue == null) {
            return baseResult
        }

        if (value.isNotEmpty()) {
            val doubleValue = value.toDoubleOrNull()
                ?: return ValidationResult(baseResult.attributeName, reason = ValidationResultReason.INCORRECT_FORMAT)

            if (attribute.doubleParameter!!.minValue != null && doubleValue < attribute.doubleParameter!!.minValue!!) {
                return ValidationResult(baseResult.attributeName, reason = ValidationResultReason.LESS_THAN_MIN_VALUE)
            }

            if (attribute.doubleParameter!!.maxValue != null && doubleValue > attribute.doubleParameter!!.maxValue!!) {
                return ValidationResult(baseResult.attributeName, reason = ValidationResultReason.MORE_THAN_MAX_VALUE)
            }
        }

        return ValidationResult(getAttributeName(entityAttribute))
    }
}
