package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.EntityMetaVersionValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityAttribute
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersion
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute

class EntityMetaVersionValidatorImpl : EntityMetaVersionValidator {
    override fun validate(entityMetaVersion: EntityMetaVersion) {
        checkAttributeShortNameUniqueness(entityMetaVersion.attributes)
    }

    private fun checkAttributeShortNameUniqueness(attributes: Collection<EntityMetaVersionAttribute>) {
        if (attributes.map { it.shortName!!.lowercase() }
                .distinct().size != attributes.size) {
            error("All attributes must have unique short names")
        }
    }
}
