package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.EntityValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.ValidatorFactory
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.EntityValidationResult
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResult
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResultReason
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMeta
import ru.yandex.crm.proto.gallifrey.entitymanager.Entitymanager

class EntityValidatorImpl(
    private val factory: ValidatorFactory
) : EntityValidator {
    override fun validate(
        entityMeta: EntityMeta,
        recordAttributes: Collection<Entitymanager.EntityRecordAttribute>
    ): EntityValidationResult {
        val results = mutableListOf<ValidationResult>()
        val entityMetaAttributes = entityMeta.entityMetaVersions.first().attributes
            .associateBy { it.shortName }

        entityMetaAttributes.values.forEach { metaAttribute ->
            if ((metaAttribute.id!!.entityAttribute.isRequired!! || !metaAttribute.id!!.entityAttribute.isNullable!!)
                && !recordAttributes.any { it.name == metaAttribute.shortName }) {
                results.add(ValidationResult(metaAttribute.shortName!!, reason = ValidationResultReason.REQUIRED))
            }
        }

        recordAttributes.forEach {
            val metaAttribute = entityMetaAttributes[it.name]
            if (metaAttribute == null) {
                results.add(ValidationResult(it.name, reason = ValidationResultReason.ATTRIBUTE_DOES_NOT_EXIST))
            } else {

                val attributeValidator = factory.getValidator(metaAttribute.id!!.entityAttribute.complexType)
                val validationResult = attributeValidator.validate(it.value, metaAttribute)
                if (!validationResult.isValid) {
                    results.add(validationResult)
                }
            }
        }

        return EntityValidationResult(results)
    }
}
