package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.SimpleTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.IntAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.annotation.SimpleTypeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResult
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResultReason
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute

@SimpleTypeValidator(SimpleTypeEnum.INT)
class IntAttributeValidatorImpl: AttributeValidatorBase(), IntAttributeValidator {
    override fun validate(value: String, entityAttribute: EntityMetaVersionAttribute): ValidationResult {
        val baseResult = super.validate(value, entityAttribute)
        val attribute = entityAttribute.id!!.entityAttribute
        if (!baseResult.isValid && attribute.integerParameter!!.defaultValue == null) {
            return baseResult
        }

        if (value.isNotEmpty()) {
            val intValue = value.toIntOrNull()
                ?: return ValidationResult(baseResult.attributeName, reason = ValidationResultReason.INCORRECT_FORMAT)

            if (attribute.integerParameter!!.minValue != null && intValue < attribute.integerParameter!!.minValue!!) {
                return ValidationResult(baseResult.attributeName, reason = ValidationResultReason.LESS_THAN_MIN_VALUE)
            }

            if (attribute.integerParameter!!.maxValue != null && intValue > attribute.integerParameter!!.maxValue!!) {
                return ValidationResult(baseResult.attributeName, reason = ValidationResultReason.MORE_THAN_MAX_VALUE)
            }
        }

        return ValidationResult(getAttributeName(entityAttribute))
    }
}

