package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl

import org.koin.core.component.KoinComponent
import org.koin.core.component.inject
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.ComplexTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.PhoneAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.StringAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.annotation.ComplexTypeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResult
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResultReason
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute

@ComplexTypeValidator(ComplexTypeEnum.PHONE_NUMBER)
class PhoneAttributeValidatorImpl : PhoneAttributeValidator, KoinComponent {
    private val stringValidator: StringAttributeValidator by inject()
    private val phoneRegex = Regex("^\\+[1-9]\\d{1,14}\$")

    override fun validate(value: String, entityAttribute: EntityMetaVersionAttribute): ValidationResult {
        val stringValidationResult = stringValidator.validate(value, entityAttribute)

        if (!stringValidationResult.isValid) {
            return stringValidationResult
        }

        if (value.isEmpty() && (!entityAttribute.id!!.entityAttribute.isRequired!! || entityAttribute.id!!.entityAttribute.isNullable!!)) {
            return ValidationResult(stringValidationResult.attributeName)
        }

        return if (phoneRegex.matches(value)) {
            ValidationResult(stringValidationResult.attributeName)
        } else {
            ValidationResult(stringValidationResult.attributeName, reason = ValidationResultReason.INCORRECT_FORMAT)
        }
    }
}
