package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.SimpleTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.StringAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.annotation.SimpleTypeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResult
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResultReason
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute

@SimpleTypeValidator(SimpleTypeEnum.STRING)
class StringAttributeValidatorImpl: AttributeValidatorBase(), StringAttributeValidator {
    override fun validate(value: String, entityAttribute: EntityMetaVersionAttribute): ValidationResult {
        val baseResult = super.validate(value, entityAttribute)
        val attribute = entityAttribute.id!!.entityAttribute
        if (!baseResult.isValid && attribute.stringParameter!!.defaultValue == null) {
            return baseResult
        }

        if (attribute.stringParameter!!.maxLength == null || value.length <= attribute.stringParameter!!.maxLength!!) {
            return ValidationResult(baseResult.attributeName)
        }
        return ValidationResult(baseResult.attributeName, reason = ValidationResultReason.LENGTH_MORE_THAN_MAX_LENGTH)
    }
}
