package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.SimpleTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.TimeAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.annotation.SimpleTypeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResult
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResultReason
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute
import java.time.LocalTime
import java.time.format.DateTimeParseException

@SimpleTypeValidator(SimpleTypeEnum.TIME)
class TimeAttributeValidatorImpl : AttributeValidatorBase(), TimeAttributeValidator {
    override fun validate(value: String, entityAttribute: EntityMetaVersionAttribute): ValidationResult {
        val baseResult = super.validate(value, entityAttribute)
        if (!baseResult.isValid && (entityAttribute.id!!.entityAttribute.timeParameter!!.defaultValue == null
                && entityAttribute.id!!.entityAttribute.timeParameter!!.nowIsDefault != true)
        ) {
            return baseResult
        }

        if (value.isNotEmpty()) {
            try {
                LocalTime.parse(value)
            } catch (ex: DateTimeParseException) {
                return ValidationResult(baseResult.attributeName, reason = ValidationResultReason.INCORRECT_FORMAT)
            }
        }

        return ValidationResult(baseResult.attributeName)
    }
}
