package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.SimpleTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.TimestampAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.annotation.SimpleTypeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResult
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResultReason
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute
import java.time.Instant
import java.time.format.DateTimeParseException

@SimpleTypeValidator(SimpleTypeEnum.TIMESTAMP)
class TimestampAttributeValidatorImpl : AttributeValidatorBase(), TimestampAttributeValidator {
    override fun validate(value: String, entityAttribute: EntityMetaVersionAttribute): ValidationResult {
        val baseResult = super.validate(value, entityAttribute)
        if (!baseResult.isValid && (entityAttribute.id!!.entityAttribute.timestampParameter!!.defaultValue == null
                && entityAttribute.id!!.entityAttribute.timestampParameter!!.nowIsDefault != true)
        ) {
            return baseResult
        }

        if (value.isNotEmpty()) {
            try {
                Instant.parse(value)
            } catch (ex: DateTimeParseException) {
                return ValidationResult(baseResult.attributeName, reason = ValidationResultReason.INCORRECT_FORMAT)
            }
        }

        return ValidationResult(baseResult.attributeName)
    }
}
