package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.SimpleTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.UuidAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.annotation.SimpleTypeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResult
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.model.ValidationResultReason
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute
import java.util.UUID

@SimpleTypeValidator(SimpleTypeEnum.UUID)
class UuidAttributeValidatorImpl : AttributeValidatorBase(), UuidAttributeValidator {
    override fun validate(value: String, entityAttribute: EntityMetaVersionAttribute): ValidationResult {
        val baseResult = super.validate(value, entityAttribute)

        if (!baseResult.isValid || value.isEmpty()) {
            return baseResult
        }

        return try {
            UUID.fromString(value)

            baseResult
        } catch (ex: IllegalArgumentException) {
            ValidationResult(baseResult.attributeName, reason = ValidationResultReason.INCORRECT_FORMAT)
        }
    }
}
