package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl

import org.koin.core.component.KoinComponent
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.mappers.impl.toEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.ComplexTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.SimpleTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.AttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.ComplexAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.SimpleAttributeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.ValidatorFactory
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.annotation.ComplexTypeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.annotation.SimpleTypeValidator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.ComplexType

class ValidatorFactoryImpl: ValidatorFactory, KoinComponent {
    private val simpleValidatorsMap: Map<SimpleTypeEnum, SimpleAttributeValidator> by lazy {
        getAttributeValidatorsMap<SimpleTypeEnum, SimpleTypeValidator, SimpleAttributeValidator> { input -> input.type }
    }

    private val complexValidatorsMap: Map<ComplexTypeEnum, ComplexAttributeValidator> by lazy {
        getAttributeValidatorsMap<ComplexTypeEnum, ComplexTypeValidator, ComplexAttributeValidator> { input -> input.type }
    }

    override fun getValidator(complexType: ComplexType): AttributeValidator {
        val complexTypeEnum = ComplexTypeEnum.values().firstOrNull { it.name == complexType.name!! }
        if (complexTypeEnum != null && complexValidatorsMap[complexTypeEnum] != null) {
            return complexValidatorsMap[complexTypeEnum]!!
        }

        return simpleValidatorsMap[complexType.simpleType.toEnum()]!!
    }

    private inline fun <TEnum, reified TAnnotation, reified TValidator> getAttributeValidatorsMap(enumGetter: (input: TAnnotation) -> TEnum)
        : Map<TEnum, TValidator> {
        val validatorsMap = mutableMapOf<TEnum, TValidator>()
        getKoin().getAll<TValidator>().forEach { attributeValidator ->
            val annotation = attributeValidator!!::class.annotations.find {
                it.annotationClass == TAnnotation::class
            } as? TAnnotation

            if (annotation != null) {
                validatorsMap[enumGetter(annotation)] = attributeValidator
            }
        }

        return validatorsMap
    }
}

