package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.externaldata.jooq

import org.jooq.Configuration
import org.jooq.impl.DSL
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.externaldata.ExternalDataCommandProvider
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.externaldata.model.ExternalDataCommand
import ru.yandex.crm.generated.database.entitymanager.entitymanager.tables.references.EXTERNAL_META_COMMAND_MAP
import java.util.*

class JooqExternalDataCommandProvider(
    private val jooqConfiguration: Configuration
) : ExternalDataCommandProvider {

    override fun getCommand(entityMetaId: UUID): ExternalDataCommand? {
        return jooqConfiguration.dsl()
            .select(EXTERNAL_META_COMMAND_MAP.ENTITY_META_ID, EXTERNAL_META_COMMAND_MAP.COMMAND_NAME)
            .from(EXTERNAL_META_COMMAND_MAP)
            .where(EXTERNAL_META_COMMAND_MAP.ENTITY_META_ID.eq(DSL.cast(entityMetaId, UUID::class.java)))
            .fetchOneInto(ExternalDataCommand::class.java)
    }
}
