package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository

import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMeta
import ru.yandex.crm.library.kotlin.database.Repository
import java.util.*

interface EntityMetaRepository : Repository<EntityMeta, UUID> {
    fun findByOrganizationId(organizationId: Long): List<EntityMeta>

    fun findByIds(organizationId: Long, metaIds: Collection<UUID>): List<EntityMeta>

    fun findById(organizationId: Long, entityMetaId: UUID, loadHierarchically: Boolean = false): EntityMeta?

    fun findByShortNameAndVersion(
        organizationId: Long,
        shortName: String,
        versionNumber: Int? = null,
        loadHierarchically: Boolean = false
    ): EntityMeta?

    fun findDraftById(organizationId: Long, entityMetaId: UUID): EntityMeta?
}
