package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.impl

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityAttributeNameRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityAttributeName
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityAttributeNameId
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityVersionStatusEnum
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository
import java.util.*

class EntityAttributeNameRepositoryImpl(session: Session) :
    HibernateRepository<EntityAttributeName, EntityAttributeNameId>(session, EntityAttributeName::class.java),
    EntityAttributeNameRepository {

    override fun findByEntityMetaIdAndShortName(
        organizationId: Long,
        entityMetaId: UUID,
        shortName: String,
        languageCode: String
    ): EntityAttributeName? {
        val query = """
            select distinct attributeName from EntityAttributeName as attributeName
            join attributeName.id.entityAttribute as entityAttribute
            join entityAttribute.versionAttributes as versionAttribute
            where attributeName.id.entityAttribute.entityMeta.id = :entityMetaId
            and attributeName.id.entityAttribute.entityMeta.organizationId = :organizationId
            and attributeName.id.languageCode = :languageCode
            and versionAttribute.shortName = :shortName
            and versionAttribute.id.entityMetaVersion.status.id = :status
        """.trimIndent()

        return findOne(
            query,
            "entityMetaId" to entityMetaId,
            "organizationId" to organizationId,
            "shortName" to shortName,
            "languageCode" to languageCode,
            "status" to EntityVersionStatusEnum.ACTIVE.value
        )
    }
}
