package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.impl

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityAttributeRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityAttribute
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository
import java.util.*

class EntityAttributeRepositoryImpl(session: Session) :
    HibernateRepository<EntityAttribute, UUID>(session, EntityAttribute::class.java),
    EntityAttributeRepository {

    override fun findNextFieldNumber(entityMetaId: UUID): Int {
        val query = session.createQuery("SELECT max(fieldNumber) + 1 from EntityAttribute where entityMeta.id = :entityMetaId")
        query.setParameter("entityMetaId", entityMetaId)
        val maxFieldNumber = query.singleResult

        return if (maxFieldNumber is Int) {
            maxFieldNumber
        } else {
            0
        }
    }
}
