package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.impl

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityMetaNameRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaName
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaNameId
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository
import java.util.*

class EntityMetaNameRepositoryImpl(session: Session) :
    HibernateRepository<EntityMetaName, EntityMetaNameId>(session, EntityMetaName::class.java),
    EntityMetaNameRepository {

    override fun findByEntityMetaId(organizationId: Long, entityMetaId: UUID, languageCode: String): EntityMetaName? {
        val query = """
            from EntityMetaName
            where id.entityMeta.id = :entityMetaId
            and id.entityMeta.organizationId = :organizationId
            and id.languageCode = :languageCode
        """.trimIndent()

        return findOne(
            query,
            "entityMetaId" to entityMetaId,
            "organizationId" to organizationId,
            "languageCode" to languageCode
        )
    }
}
