package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.impl

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityMetaVersionAttributeRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttributeId
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityVersionStatusEnum
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository
import java.util.*

class EntityMetaVersionAttributeRepositoryImpl(session: Session) :
    HibernateRepository<EntityMetaVersionAttribute, EntityMetaVersionAttributeId>(
        session,
        EntityMetaVersionAttribute::class.java
    ),
    EntityMetaVersionAttributeRepository {

    override fun findByEntityMetaIdAndOrganizationId(
        organizationId: Long,
        entityMetaId: UUID,
        shortName: String
    ): EntityMetaVersionAttribute? {
        val query = """
            select distinct entityVersionAttribute from EntityMetaVersionAttribute as entityVersionAttribute
            join fetch entityVersionAttribute.id.entityAttribute
            where entityVersionAttribute.shortName = :shortName
            and entityVersionAttribute.id.entityMetaVersion.entityMeta.id = :entityMetaId
            and entityVersionAttribute.id.entityMetaVersion.entityMeta.organizationId = :organizationId
            and entityVersionAttribute.id.entityMetaVersion.status.id = :status
        """.trimIndent()

        return findOne(
            query,
            "entityMetaId" to entityMetaId,
            "organizationId" to organizationId,
            "shortName" to shortName,
            "status" to EntityVersionStatusEnum.ACTIVE.value
        )
    }
}
