package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.impl

import org.hibernate.Session
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.EntityMetaVersionRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersion
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityVersionStatusEnum
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateRepository
import java.util.*

class EntityMetaVersionRepositoryImpl(session: Session) :
    HibernateRepository<EntityMetaVersion, UUID>(session, EntityMetaVersion::class.java), EntityMetaVersionRepository {

    override fun findDraftByEntityMetaId(organizationId: Long, entityMetaId: UUID): EntityMetaVersion? {
        return findByIdAndStatus(organizationId, entityMetaId, EntityVersionStatusEnum.DRAFT)
    }

    override fun findActiveByEntityMetaId(organizationId: Long, entityMetaId: UUID): EntityMetaVersion? {
        return findByIdAndStatus(organizationId, entityMetaId, EntityVersionStatusEnum.ACTIVE)
    }

    private fun findByIdAndStatus(
        organizationId: Long,
        entityMetaId: UUID,
        status: EntityVersionStatusEnum
    ): EntityMetaVersion? {
        return findOne(
            "from EntityMetaVersion where entityMeta.id = :entityMetaId and entityMeta.organizationId = :organizationId and status.id = :status and entityMeta.isDeleted = false",
            "entityMetaId" to entityMetaId,
            "organizationId" to organizationId,
            "status" to status.value
        )
    }
}
