package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model

import javax.persistence.*

@Entity
@Table(
    name = "complex_type",
    schema = "entitymanager"
)
open class ComplexType(
    @Id
    @GeneratedValue(strategy = GenerationType.IDENTITY)
    @Column(name = "id", nullable = false, updatable = false)
    open var id: Short? = null,

    @Column(name = "name", nullable = false, length = 64, unique = true)
    open var name: String? = null,

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "simple_type_id")
    open var simpleType: SimpleType = SimpleType()
)
