package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model

import org.hibernate.annotations.GenericGenerator
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.parameter.*
import java.util.*
import javax.persistence.*

@Entity
@Table(name = "entity_attribute", schema = "entitymanager")
open class EntityAttribute(

    @Id
    @GeneratedValue(generator = "UUID")
    @GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
    @Column(name = "id", nullable = false, updatable = false)
    open var id: UUID? = null,

    @Column(name = "is_required", nullable = false)
    open var isRequired: Boolean? = null,

    @Column(name = "is_nullable", nullable = false)
    open var isNullable: Boolean? = null,

    @Column(name = "field_number", nullable = false)
    open var fieldNumber: Int? = null,

    @ManyToOne(cascade = [CascadeType.ALL], fetch = FetchType.LAZY)
    @JoinColumn(name = "entity_meta_id")
    open var entityMeta: EntityMeta = EntityMeta(),

    @ManyToOne(cascade = [CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH], fetch = FetchType.LAZY)
    @JoinColumn(name = "complex_type_id")
    open var complexType: ComplexType = ComplexType(),

    @OneToMany(mappedBy = "id.entityAttribute", cascade = [CascadeType.ALL])
    open var names: MutableSet<EntityAttributeName> = mutableSetOf(),

    @OneToMany(mappedBy = "id.entityAttribute", cascade = [CascadeType.ALL])
    open var versionAttributes: MutableSet<EntityMetaVersionAttribute> = mutableSetOf(),

    @PrimaryKeyJoinColumn
    @OneToOne(mappedBy = "entityAttribute", cascade = [CascadeType.ALL], fetch = FetchType.LAZY)
    open var integerParameter: EntityIntegerAttributeParameter? = null,

    @PrimaryKeyJoinColumn
    @OneToOne(mappedBy = "entityAttribute", cascade = [CascadeType.ALL], fetch = FetchType.LAZY)
    open var doubleParameter: EntityDoubleAttributeParameter? = null,

    @PrimaryKeyJoinColumn
    @OneToOne(mappedBy = "entityAttribute", cascade = [CascadeType.ALL], fetch = FetchType.LAZY)
    open var stringParameter: EntityStringAttributeParameter? = null,

    @PrimaryKeyJoinColumn
    @OneToOne(mappedBy = "entityAttribute", cascade = [CascadeType.ALL], fetch = FetchType.LAZY)
    open var dateParameter: EntityDateAttributeParameter? = null,

    @PrimaryKeyJoinColumn
    @OneToOne(mappedBy = "entityAttribute", cascade = [CascadeType.ALL], fetch = FetchType.LAZY)
    open var timeParameter: EntityTimeAttributeParameter? = null,

    @PrimaryKeyJoinColumn
    @OneToOne(mappedBy = "entityAttribute", cascade = [CascadeType.ALL], fetch = FetchType.LAZY)
    open var timestampParameter: EntityTimestampAttributeParameter? = null,

    @PrimaryKeyJoinColumn
    @OneToOne(mappedBy = "entityAttribute", cascade = [CascadeType.ALL], fetch = FetchType.LAZY)
    open var linkParameter: EntityLinkAttributeParameter? = null
)
