package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model

import java.io.Serializable
import javax.persistence.*

@Embeddable
open class EntityAttributeNameId(

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "entity_attribute_id", referencedColumnName = "id")
    open var entityAttribute: EntityAttribute = EntityAttribute(),

    @Column(name = "language_code", length = 2, nullable = false)
    open var languageCode: String? = null
) : Serializable {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EntityAttributeNameId

        if (entityAttribute.id != other.entityAttribute.id) return false
        if (languageCode != other.languageCode) return false

        return true
    }

    override fun hashCode(): Int {
        var result = entityAttribute.id.hashCode()
        result = 31 * result + languageCode.hashCode()
        return result
    }
}
