package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model

import org.hibernate.annotations.GenericGenerator
import java.time.Instant
import java.util.*
import javax.persistence.*

@Entity
@Table(name = "entity_meta", schema = "entitymanager")
open class EntityMeta(

    @Id
    @GeneratedValue(generator = "UUID")
    @GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
    @Column(name = "id", nullable = false, updatable = false)
    open var id: UUID? = null,

    @Column(name = "organization_id", nullable = false)
    open var organizationId: Long? = null,

    @Column(name = "short_name", nullable = false, length = 255)
    open var shortName: String? = null,

    @Column(name = "is_deleted", nullable = false)
    open var isDeleted: Boolean? = null,

    @Column(name = "created_by", nullable = false)
    open var createdBy: Long? = null,

    @Column(name = "created_at", nullable = false)
    open var createdAt: Instant? = null,

    @OneToMany(mappedBy = "id.entityMeta", cascade = [CascadeType.ALL])
    open var names: MutableSet<EntityMetaName> = mutableSetOf(),

    @OneToMany(mappedBy = "entityMeta", cascade = [CascadeType.ALL])
    open var entityMetaVersions: MutableSet<EntityMetaVersion> = mutableSetOf(),

    @OneToMany(mappedBy = "entityMeta", cascade = [CascadeType.ALL])
    open var entityAttributes: MutableSet<EntityAttribute> = mutableSetOf()
)
