package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model

import java.io.Serializable
import javax.persistence.*

@Embeddable
open class EntityMetaNameId(

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "entity_meta_id", referencedColumnName = "id")
    open var entityMeta: EntityMeta = EntityMeta(),

    @Column(name = "language_code", length = 2, nullable = false)
    open var languageCode: String? = null
) : Serializable {

    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EntityMetaNameId

        if (entityMeta.id != other.entityMeta.id) return false
        if (languageCode != other.languageCode) return false

        return true
    }

    override fun hashCode(): Int {
        var result = entityMeta.id.hashCode()
        result = 31 * result + languageCode.hashCode()
        return result
    }
}
