package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model

import org.hibernate.annotations.GenericGenerator
import java.time.Instant
import java.util.*
import javax.persistence.*

@Entity
@Table(name = "entity_meta_version", schema = "entitymanager")
open class EntityMetaVersion(

    @Id
    @GeneratedValue(generator = "UUID")
    @GenericGenerator(name = "UUID", strategy = "org.hibernate.id.UUIDGenerator")
    @Column(name = "id", nullable = false, updatable = false)
    open var id: UUID? = null,

    @Column(name = "version_number", nullable = false)
    open var versionNumber: Int? = null,

    @Column(name = "created_by", nullable = false)
    open var createdBy: Long? = null,

    @Column(name = "created_at", nullable = false)
    open var createdAt: Instant? = null,

    @Column(name = "changed_by", nullable = true)
    open var changedBy: Long? = 0,

    @Column(name = "changed_at", nullable = true)
    open var changedAt: Instant? = null,

    @ManyToOne(cascade = [CascadeType.ALL], fetch = FetchType.LAZY)
    @JoinColumn(name = "entity_meta_id")
    open var entityMeta: EntityMeta = EntityMeta(),

    @ManyToOne(fetch = FetchType.LAZY, cascade = [CascadeType.MERGE, CascadeType.PERSIST, CascadeType.REFRESH])
    @JoinColumn(name = "status_id")
    open var status: EntityVersionStatus = EntityVersionStatus(),

    @OneToMany(mappedBy = "id.entityMetaVersion", cascade = [CascadeType.ALL])
    open var attributes: MutableSet<EntityMetaVersionAttribute> = mutableSetOf()
)
