package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model

import java.io.Serializable
import javax.persistence.Embeddable
import javax.persistence.FetchType
import javax.persistence.JoinColumn
import javax.persistence.ManyToOne

@Embeddable
open class EntityMetaVersionAttributeId(

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "entity_meta_version_id", referencedColumnName = "id")
    open var entityMetaVersion: EntityMetaVersion = EntityMetaVersion(),

    @ManyToOne(fetch = FetchType.LAZY)
    @JoinColumn(name = "entity_attribute_id", referencedColumnName = "id")
    open var entityAttribute: EntityAttribute = EntityAttribute(),
) : Serializable {
    override fun equals(other: Any?): Boolean {
        if (this === other) return true
        if (javaClass != other?.javaClass) return false

        other as EntityMetaVersionAttributeId

        if (entityMetaVersion.id != other.entityMetaVersion.id) return false
        if (entityAttribute.id != other.entityAttribute.id) return false

        return true
    }

    override fun hashCode(): Int {
        var result = entityMetaVersion.id.hashCode()
        result = 31 * result + entityAttribute.id.hashCode()
        return result
    }
}
