package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.ut

import org.koin.test.KoinTest
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.ComplexTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.model.SimpleTypeEnum
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.ComplexType
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityAttribute
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttributeId
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.SimpleType
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.parameter.EntityIntegerAttributeParameter
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.parameter.EntityLinkAttributeParameter
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.parameter.EntityStringAttributeParameter
import java.util.UUID

abstract class BaseEntityMetaTest : KoinTest {
    protected fun buildStringAttribute(name: String, isRequired: Boolean = true, isNullable: Boolean = false) : EntityMetaVersionAttribute {
        return EntityMetaVersionAttribute(
            EntityMetaVersionAttributeId(
                entityAttribute = EntityAttribute(
                    complexType = ComplexType(
                        name = "STRING",
                        simpleType = SimpleType(SimpleTypeEnum.STRING.value, "STRING")
                    ),
                    isRequired = isRequired,
                    isNullable = isNullable,
                    stringParameter = EntityStringAttributeParameter()
                )
            ), name
        )
    }

    protected fun buildIntAttribute(name: String) : EntityMetaVersionAttribute {
        return EntityMetaVersionAttribute(
            EntityMetaVersionAttributeId(
                entityAttribute = EntityAttribute(
                    complexType = ComplexType(
                        name = "INT",
                        simpleType = SimpleType(SimpleTypeEnum.INT.value, "INT")
                    ),
                    isRequired = true,
                    isNullable = false,
                    integerParameter = EntityIntegerAttributeParameter()
                )
            ), name
        )
    }

    protected fun buildEmailAttribute(name: String) : EntityMetaVersionAttribute {
        return EntityMetaVersionAttribute(
            EntityMetaVersionAttributeId(
                entityAttribute = EntityAttribute(
                    complexType = ComplexType(
                        name = "EMAIL",
                        simpleType = SimpleType(SimpleTypeEnum.STRING.value, "STRING")
                    ),
                    isRequired = true,
                    isNullable = false,
                    stringParameter = EntityStringAttributeParameter()
                )
            ), name
        )
    }

    protected fun buildLinkAttribute(name: String, isFirst: Boolean, targetEntityMeta: UUID? = null) : EntityMetaVersionAttribute {
        return EntityMetaVersionAttribute(
            EntityMetaVersionAttributeId(
                entityAttribute = EntityAttribute(
                    complexType = ComplexType(
                        name = ComplexTypeEnum.LINK.name,
                        simpleType = SimpleType(SimpleTypeEnum.STRING.value, "STRING")
                    ),
                    isRequired = true,
                    isNullable = false,
                    linkParameter = EntityLinkAttributeParameter(
                        isFirst = isFirst,
                        target = targetEntityMeta ?: UUID.randomUUID()
                    )
                )
            ), name
        )
    }
}
