package ru.yandex.crm.apphost.kotlin.handlers.entitymanager.ut.entitymeta.validator

import org.junit.jupiter.api.assertThrows
import org.koin.test.KoinTest
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.entitymeta.validator.impl.EntityMetaVersionValidatorImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMeta
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersion
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityMetaVersionAttribute
import ru.yandex.crm.apphost.kotlin.handlers.entitymanager.repository.model.EntityVersionStatus
import java.time.Instant
import java.util.UUID
import kotlin.test.Test

class EntityMetaVersionValidatorAttributeTests : KoinTest {
    val validator = EntityMetaVersionValidatorImpl()

    @Test
    fun `when all shortNames are unique validation not throws`() {
        //Arrange
        val entityMetaVersion = EntityMetaVersion(
            UUID.randomUUID(), 1, 1, Instant.now(), null, null,
            entityMeta = EntityMeta(UUID.randomUUID(), 1, "test"),
            status = EntityVersionStatus(1, ""),
            attributes = mutableSetOf(
                EntityMetaVersionAttribute(id = null, "attribute1"),
                EntityMetaVersionAttribute(id = null, "attribute2"),
                EntityMetaVersionAttribute(id = null, "attribute3")
            )
        )

        //Act
        validator.validate(entityMetaVersion)
    }

    @Test
    fun `when there are not unique validation throws`() {
        //Arrange
        val entityMetaVersion = EntityMetaVersion(
            UUID.randomUUID(), 1, 1, Instant.now(), null, null,
            entityMeta = EntityMeta(UUID.randomUUID(), 1, "test"),
            status = EntityVersionStatus(1, ""),
            attributes = mutableSetOf(
                EntityMetaVersionAttribute(id = null, "attribute1"),
                EntityMetaVersionAttribute(id = null, "attribute2"),
                EntityMetaVersionAttribute(id = null, "attribute2")
            )
        )

        //Act
        assertThrows<IllegalStateException> { validator.validate(entityMetaVersion) }
    }

    @Test
    fun `when there are not unique in different cases validation throws`() {
        //Arrange
        val entityMetaVersion = EntityMetaVersion(
            UUID.randomUUID(), 1, 1, Instant.now(), null, null,
            entityMeta = EntityMeta(UUID.randomUUID(), 1, "test"),
            status = EntityVersionStatus(1, ""),
            attributes = mutableSetOf(
                EntityMetaVersionAttribute(id = null, "attribute1"),
                EntityMetaVersionAttribute(id = null, "attribute2"),
                EntityMetaVersionAttribute(id = null, "Attribute2")
            )
        )

        //Act
        assertThrows<IllegalStateException> { validator.validate(entityMetaVersion) }
    }
}
