DO $$
DECLARE
metas_count smallint;
l_user_id integer;
l_meta_id uuid;
l_meta_version_id uuid;
begin
-- CREATE EXTENSION IF NOT EXISTS "uuid-ossp";
metas_count = 10000;
INSERT INTO entitystorage.entity_user (external_id) VALUES (metas_count) RETURNING id into l_user_id;
FOR i IN 1..metas_count LOOP
-- inserting meta
    INSERT INTO entitystorage.meta (created_at, created_by, is_deleted, organization_id, short_name, table_name, table_schema, id)
            VALUES (NOW(), l_user_id, false, 1, 'meta' || i, '', '', uuid_generate_v4()) RETURNING id into l_meta_id;

-- inserting meta_version
    INSERT INTO entitystorage.meta_version (created_at, created_by, meta_id, status, version_number, id)
    VALUES (NOW(), l_user_id, l_meta_id, 1, 1, uuid_generate_v4()) RETURNING id into l_meta_version_id;

-- inserting attributes
    INSERT INTO entitystorage."attribute" (field_number, is_indexed, is_nullable, is_required, meta_version_id, short_name, default_value, max_length, "type", id)
    VALUES (0, true, true, false, l_meta_version_id, 'attribute0' , null, null, 'STRING', uuid_generate_v4());

    INSERT INTO entitystorage."attribute" (field_number, is_indexed, is_nullable, is_required, meta_version_id, short_name, default_value, max_length, "type", id)
    VALUES (1, true, true, false, l_meta_version_id, 'attribute1' , null, null, 'INT', uuid_generate_v4());

    INSERT INTO entitystorage."attribute" (field_number, is_indexed, is_nullable, is_required, meta_version_id, short_name, default_value, max_length, "type", id)
    VALUES (2, true, true, false, l_meta_version_id, 'attribute2' , null, null, 'TIMESTAMP', uuid_generate_v4());

    INSERT INTO entitystorage."attribute" (field_number, is_indexed, is_nullable, is_required, meta_version_id, short_name, default_value, max_length, "type", id)
    VALUES (3, false, true, false, l_meta_version_id, 'attribute3' , null, null, 'STRING', uuid_generate_v4());

    INSERT INTO entitystorage."attribute" (field_number, is_indexed, is_nullable, is_required, meta_version_id, short_name, default_value, max_length, "type", id)
    VALUES (4, false, true, false, l_meta_version_id, 'attribute4' , null, null, 'INT', uuid_generate_v4());

    INSERT INTO entitystorage."attribute" (field_number, is_indexed, is_nullable, is_required, meta_version_id, short_name, default_value, max_length, "type", id)
    VALUES (5, false, true, false, l_meta_version_id, 'attribute5' , null, null, 'TIMESTAMP', uuid_generate_v4());

    INSERT INTO entitystorage."attribute" (field_number, is_indexed, is_nullable, is_required, meta_version_id, short_name, default_value, max_length, "type", id)
    VALUES (6, false, true, false, l_meta_version_id, 'attribute6' , null, null, 'STRING', uuid_generate_v4());

    INSERT INTO entitystorage."attribute" (field_number, is_indexed, is_nullable, is_required, meta_version_id, short_name, default_value, max_length, "type", id)
    VALUES (7, false, true, false, l_meta_version_id, 'attribute7' , null, null, 'INT', uuid_generate_v4());

    INSERT INTO entitystorage."attribute" (field_number, is_indexed, is_nullable, is_required, meta_version_id, short_name, default_value, max_length, "type", id)
    VALUES (8, false, true, false, l_meta_version_id, 'attribute8' , null, null, 'TIMESTAMP', uuid_generate_v4());

    INSERT INTO entitystorage."attribute" (field_number, is_indexed, is_nullable, is_required, meta_version_id, short_name, default_value, max_length, "type", id)
    VALUES (9, false, true, false, l_meta_version_id, 'attribute9' , null, null, 'STRING', uuid_generate_v4());

END LOOP;
end;
$$;
