package ru.yandex.crm.apphost.kotlin.handlers.entitystorage.config

import org.koin.dsl.bind
import org.koin.dsl.module
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.EntityService
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.EntityUserService
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.AttributeFilterMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.AttributeSchemaMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.AttributeTypeMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.EntityMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.EntitySchemaMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.EntityUserMapper
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.impl.AttributeFilterMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.impl.AttributeSchemaMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.impl.AttributeTypeMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.impl.EntityMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.impl.EntitySchemaMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.api.mapper.impl.EntityUserMapperImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.EntityRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.EntityUserRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.IndexRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.MetaSchema
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.SchemalessEntityRepository
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.impl.EntityRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.impl.EntityUserRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.impl.IndexRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.repository.impl.SchemalessEntityRepositoryImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.service.EntityManagementService
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.service.EntityUserManager
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.service.impl.EntityManagementServiceImpl
import ru.yandex.crm.apphost.kotlin.handlers.entitystorage.service.impl.EntityUserManagerImpl
import ru.yandex.crm.library.kotlin.database.hibernate.HibernateSchema
import ru.yandex.crm.library.kotlin.service.HostBuilder
import ru.yandex.web.apphost.api.grpc.AppHostTypedServant

fun HostBuilder.withEntityStorageModule() = withModule(
    module {
        single { EntityManagementServiceImpl() } bind EntityManagementService::class
        single { EntityUserManagerImpl() } bind EntityUserManager::class
        single { MetaSchema() } bind HibernateSchema::class

        // entity service
        single { EntityService(get(), get(), get(), get(), get()) } bind AppHostTypedServant::class
        single { EntityUserService(get(), get()) } bind AppHostTypedServant::class

        //mappers
        single { EntitySchemaMapperImpl(get()) } bind EntitySchemaMapper::class
        single { AttributeSchemaMapperImpl(get()) } bind AttributeSchemaMapper::class
        single { AttributeTypeMapperImpl() } bind AttributeTypeMapper::class
        single { EntityMapperImpl(get()) } bind EntityMapper::class
        single { AttributeFilterMapperImpl(get())} bind AttributeFilterMapper::class
        single { EntityUserMapperImpl()} bind EntityUserMapper::class

        // repositories
        factory { params -> EntityRepositoryImpl(params.get(), params.get()) } bind EntityRepository::class
        factory { params -> SchemalessEntityRepositoryImpl(params.get()) } bind SchemalessEntityRepository::class
        factory { params -> IndexRepositoryImpl(params.get()) } bind IndexRepository::class
        factory { params -> EntityUserRepositoryImpl(params.get()) } bind EntityUserRepository::class
    }
)
